clear

foreach var in Prim_Enr_GPI Sec_Enr_GPI Tert_Enr_GPI {
	    local file "All_pvals_`var'22allyrs_Finalcomplete.dta"

    use "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'", clear

    save "R:\Reina\Replication_Gender_July13\Appendix Table Results/All_pvals_`var'22allyrs_FinalALLcomplete.dta", replace
	
}

tempfile results
save `results', emptyok

foreach var in LFPR_Fem_ILO Ad_Fert_R F_M_LFPR_RATIO GII Mat_Mort_R_MO Prim_Enr_GPI Sec_Enr_GPI Tert_Enr_GPI {

    local file "All_pvals_`var'22allyrs_FinalALLcomplete.dta"
    use "R:\Reina\Replication_Gender_July13\Appendix Table Results/`file'", clear

    count
    local total = r(N)

    count if classification == "Significantly Positive"
    local pos = r(N)

    count if classification == "Significantly Negative"
    local neg = r(N)

    local nonsig = `total' - `pos' - `neg'
    gen str40 variable = "`var'"
    gen programs = `total'
    gen pos_sig = `pos'
    gen neg_sig = `neg'
    gen nonsig_count = `nonsig'
    gen str nonsig_display = string(`nonsig') + " (" + string(round(100*`nonsig'/`total',1)) + "%)"

    keep variable programs pos_sig neg_sig nonsig_display
    append using `results'
    save `results', replace
}

use `results', clear
list, sep(0)

duplicates drop 
sort variable
drop if variable ==""
drop countryname-classification